/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CListView.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CListView_h	// [
#define Included_CListView_h

#include "pgpClassesConfig.h"
#include <commctrl.h>

#include "CImageList.h"
#include "CWindow.h"

_PGP_BEGIN

// Class CListView

class CListView : public CWindow
{
public:
	CListView() { }
	CListView(HWND hWnd) : CWindow(hWnd) { }
	~CListView() { }

	PGPBoolean	DeleteAllItems() const
	{
		return static_cast<PGPBoolean>(SendMessage(LVM_DELETEALLITEMS));
	}

	PGPBoolean	DeleteItem(PGPInt32 i) const
	{
		return static_cast<PGPBoolean>(SendMessage(LVM_DELETEITEM, i));
	}

	PGPBoolean	EnsureVisable(PGPInt32 i, PGPBoolean partialOK) const
	{
		return static_cast<PGPBoolean>(SendMessage(LVM_ENSUREVISIBLE, i, 
			partialOK));
	}

	PGPBoolean	DeleteColumn(PGPInt32 column) const
	{
		return static_cast<PGPBoolean>(SendMessage(LVM_DELETECOLUMN, column));
	}

	PGPUInt32	GetColumnWidth(PGPInt32 iCol) const
	{
		return SendMessage(LVM_GETCOLUMNWIDTH, iCol);
	}

	PGPBoolean	GetItem(LPLVITEM pItem) const
	{
		return static_cast<PGPBoolean>(SendMessage(LVM_GETITEM, 0, 
			reinterpret_cast<LPARAM>(pItem)));
	}

	PGPUInt32	GetItemCount() const
	{
		return SendMessage(LVM_GETITEMCOUNT);
	}

	PGPBoolean	GetItemRect(PGPInt32 i, RECT *pRect, PGPInt32 code) const;

	PGPUInt32	GetItemState(PGPInt32 i, PGPUInt32 mask) const
	{
		return SendMessage(LVM_GETITEMSTATE, i, mask);
	}

	PGPUInt32	GetSelectedCount() const
	{
		return SendMessage(LVM_GETSELECTEDCOUNT);
	}

	PGPInt32	FindItem(PGPInt32 iStart, LVFINDINFO *pFindInfo) const
	{
		return SendMessage(LVM_FINDITEM, iStart, 
			reinterpret_cast<LPARAM>(pFindInfo));
	}

	PGPInt32	InsertColumn(PGPInt32 iCol, LPLVCOLUMN pLVC) const
	{
		return SendMessage(LVM_INSERTCOLUMN, iCol, 
			reinterpret_cast<LPARAM>(pLVC));
	}

	PGPInt32	InsertItem(LPLVITEM pItem) const
	{
		return SendMessage(LVM_INSERTITEM, 0, 
			reinterpret_cast<LPARAM>(pItem));
	}

	PGPBoolean	RedrawItems(PGPInt32 iFirst, PGPInt32 iLast) const
	{
		return static_cast<PGPBoolean>(SendMessage(LVM_REDRAWITEMS, iFirst, 
			iLast));
	}

	PGPUInt32	SetExtendedStyle(PGPUInt32 style, PGPUInt32 mask) const
	{
		return SendMessage(LVM_SETEXTENDEDLISTVIEWSTYLE, style, mask);
	}

	PGPBoolean	SetItemState(PGPInt32 i, PGPUInt32 state, PGPUInt32 mask);

	PGPBoolean	SortItems(PFNLVCOMPARE pfnCompare, LPARAM lParamSort) const
	{
		return static_cast<PGPBoolean>(SendMessage(LVM_SORTITEMS, 
			lParamSort, reinterpret_cast<LPARAM>(pfnCompare)));
	}

	void	Create(HWND parent, PGPUInt32 id, PGPUInt32 style, 
		PGPUInt32 exStyle = 0, PGPInt32 xOffset = 0, PGPInt32 yOffset = 0, 
		PGPInt32 width = 0, PGPInt32 height = 0);
};

_PGP_END

#endif	// ] Included_CListView_h
